/*
 * Decompiled with CFR 0.152.
 */
package jp.yucchi.search2014;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.obj.ObjModelImporter;
import java.net.URL;
import java.security.SecureRandom;
import java.util.stream.IntStream;
import javafx.animation.AnimationTimer;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Reflection;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.HBox;
import javafx.scene.media.AudioSpectrumListener;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;

class About3DWindow
implements AudioSpectrumListener {
    private double anchorAngleX;
    private double anchorAngleY;
    private final DoubleProperty angleX = new SimpleDoubleProperty(0.0);
    private final DoubleProperty angleY = new SimpleDoubleProperty(0.0);
    private double anchorX;
    private double anchorY;
    DoubleProperty angleWalk_r_X = new SimpleDoubleProperty(0.0);
    DoubleProperty angleWalk_l_X = new SimpleDoubleProperty(0.0);
    DoubleProperty angleWalk_l_arm = new SimpleDoubleProperty(0.0);
    DoubleProperty angleWalk_r_arm = new SimpleDoubleProperty(0.0);
    private final DoubleProperty xPos = new SimpleDoubleProperty(0.0);
    private final DoubleProperty yPos = new SimpleDoubleProperty(0.0);
    private final DoubleProperty zPos = new SimpleDoubleProperty(-1000.0);
    private final DoubleProperty sxPos = new SimpleDoubleProperty(1.0);
    private final DoubleProperty syPos = new SimpleDoubleProperty(1.0);
    private final DoubleProperty szPos = new SimpleDoubleProperty(1.0);
    private final DoubleProperty rxPos = new SimpleDoubleProperty(0.0);
    private final DoubleProperty ryPos = new SimpleDoubleProperty(0.0);
    private final DoubleProperty rzPos = new SimpleDoubleProperty(0.0);
    private final DoubleProperty turnAngleY = new SimpleDoubleProperty(0.0);
    private final DoubleProperty turnAngleX = new SimpleDoubleProperty(0.0);
    private AudioSpectrumListener audioSpectrumListener;
    private final Media bgm = new Media(this.getClass().getResource("Music/Bgm/bgm.mp3").toExternalForm());
    private MediaPlayer mp_bgm;
    private MeshView[] backMesh;
    private double d_vx;
    private double d_vz;
    private double azimuth;
    private long previousHandledTime;
    private final DoubleProperty azimuthRateProperty = new SimpleDoubleProperty(15.0);
    private final DoubleProperty elevationProperty = new SimpleDoubleProperty(7.0);
    private static final double SUBCAMERA_RADIUS = 5500.0;
    private Timeline dukeAnim;
    private AnimationTimer walkTimer_g;
    private Timeline turn_g;
    private final String HOVERED_BUTTON_STYLE = "-fx-text-fill: magenta; -fx-font-size: 14pt;  -fx-background-color:TRANSPARENT;-fx-background-color: white";
    private final String STANDARD_BUTTON_STYLE = "-fx-text-fill: deepskyblue; -fx-font-size: 14pt;  -fx-background-color:TRANSPARENT;-fx-background-color: white";
    private final String PRESSED_BUTTON_STYLE = "-fx-text-fill: lime; -fx-font-size: 14pt;  -fx-background-color:TRANSPARENT;-fx-background-color: white";
    private final String STANDARD_LABEL_STYLE = "-fx-font:  bold 24pt 'serif'; -fx-text-fill: hotpink; -fx-background-color:TRANSPARENT;-fx-background-color: white";
    private final String HOVERED_LABEL_STYLE = "-fx-font:  bold 24pt 'serif'; -fx-text-fill: lime; -fx-background-color:TRANSPARENT;-fx-background-color: white";
    private final AnchorPane mainAnchor;

    About3DWindow(AnchorPane mainAnchor) {
        this.mainAnchor = mainAnchor;
        this.makeWindow();
    }

    private void makeWindow() {
        Stage aboutStage = new Stage(StageStyle.TRANSPARENT);
        aboutStage.initModality(Modality.APPLICATION_MODAL);
        aboutStage.initOwner(this.mainAnchor.getScene().getWindow());
        Group root = new Group();
        Scene scene = new Scene((Parent)root, 800.0, 450.0, true);
        scene.setFill((Paint)Color.TRANSPARENT);
        PerspectiveCamera cam = new PerspectiveCamera(false);
        root.getChildren().add((Object)cam);
        scene.setCamera((Camera)cam);
        AnchorPane subRoot = new AnchorPane();
        subRoot.setBackground(Background.EMPTY);
        SubScene subScene = new SubScene((Parent)subRoot, 800.0, 450.0, true, SceneAntialiasing.BALANCED);
        subScene.setFill((Paint)Color.TRANSPARENT);
        PerspectiveCamera subCam = new PerspectiveCamera(true);
        subCam.setFieldOfView(45.5);
        subCam.setNearClip(1.0);
        subCam.setFarClip(1.0E7);
        subScene.setCamera((Camera)subCam);
        Group allGroup = new Group();
        ObjModelImporter dukeImporter = new ObjModelImporter();
        ObjModelImporter boadImporter = new ObjModelImporter();
        ObjModelImporter backImporter = new ObjModelImporter();
        try {
            URL objUrl = this.getClass().getResource("3dModel/Duke/duke.obj");
            dukeImporter.read(objUrl);
        }
        catch (ImportException e) {
            e.printStackTrace();
            return;
        }
        MeshView[] dukeMesh = dukeImporter.getImport();
        dukeImporter.close();
        final Group dukeGroup = new Group();
        for (MeshView _dukeMesh : dukeMesh) {
            dukeGroup.getChildren().addAll((Object[])new Node[]{_dukeMesh});
        }
        try {
            URL objUrl = this.getClass().getResource("3dModel/Boad/base.obj");
            boadImporter.read(objUrl);
        }
        catch (ImportException e) {
            e.printStackTrace();
            return;
        }
        MeshView[] boadMesh = boadImporter.getImport();
        boadImporter.close();
        Group boadGroup = new Group();
        for (MeshView _boadMesh : boadMesh) {
            boadGroup.getChildren().addAll((Object[])new Node[]{_boadMesh});
        }
        try {
            URL objUrl = this.getClass().getResource("3dModel/AppName/back_duke.obj");
            backImporter.read(objUrl);
        }
        catch (ImportException e) {
            e.printStackTrace();
            return;
        }
        this.backMesh = backImporter.getImport();
        backImporter.close();
        Group backGroup = new Group();
        for (MeshView _backMesh : this.backMesh) {
            backGroup.getChildren().addAll((Object[])new Node[]{_backMesh});
        }
        AmbientLight ambient = new AmbientLight();
        ambient.setColor(Color.rgb((int)150, (int)150, (int)150, (double)0.6));
        ambient.getScope().addAll((Object[])new Node[]{allGroup});
        PointLight point = new PointLight();
        point.setColor(Color.rgb((int)255, (int)255, (int)255, (double)1.0));
        point.setLayoutX(-700.0);
        point.setLayoutY(-1000.0);
        point.setTranslateZ(-2500.0);
        point.getScope().addAll((Object[])new Node[]{allGroup});
        allGroup.getChildren().addAll((Object[])new Node[]{dukeGroup, boadGroup, backGroup});
        subRoot.getChildren().addAll((Object[])new Node[]{allGroup, subCam, ambient, point});
        AnchorPane infoPane = new AnchorPane();
        infoPane.setPrefSize(800.0, 80.0);
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER_RIGHT);
        hBox.setPadding(new Insets(10.0, 24.0, 10.0, 24.0));
        infoPane.getChildren().add((Object)hBox);
        AnchorPane.setTopAnchor((Node)hBox, (Double)5.0);
        AnchorPane.setBottomAnchor((Node)hBox, (Double)5.0);
        AnchorPane.setLeftAnchor((Node)hBox, (Double)5.0);
        AnchorPane.setRightAnchor((Node)hBox, (Double)5.0);
        Reflection reflection = new Reflection();
        reflection.setTopOpacity(0.5);
        reflection.setBottomOpacity(0.0);
        reflection.setFraction(0.75);
        reflection.setTopOffset(0.05);
        Label brandNameLabel = new Label("Search 2014 Ver.1.0 by Yucchi nanoSystems");
        brandNameLabel.setStyle("-fx-font:  bold 24pt 'serif'; -fx-text-fill: hotpink;-fx-background-color: white;");
        brandNameLabel.setPadding(new Insets(10.0, 28.0, 0.0, 28.0));
        brandNameLabel.setEffect((Effect)reflection);
        hBox.getChildren().add((Object)brandNameLabel);
        Button closeButton = new Button("Close");
        closeButton.setStyle("-fx-text-fill: deepskyblue; -fx-font-size: 14pt;  -fx-background-color:TRANSPARENT;-fx-background-color: white");
        closeButton.setPadding(new Insets(18.0, 10.0, 0.0, 18.0));
        closeButton.setEffect((Effect)reflection);
        hBox.getChildren().add((Object)closeButton);
        this.changeForegroundOnHoverUsingBinding((Node)brandNameLabel);
        this.changeBackgroundMouseEventUsingEvents((Node)closeButton);
        root.getChildren().addAll((Object[])new Node[]{subScene, infoPane});
        closeButton.setOnAction(event -> {
            this.stopLine();
            FadeTransition ft = new FadeTransition(Duration.millis((double)1000.0), (Node)aboutStage.getScene().getRoot());
            ft.setFromValue(1.0);
            ft.setToValue(0.0);
            EventHandler eh = ae -> aboutStage.hide();
            ft.setOnFinished(eh);
            ft.play();
        });
        Object[] objectArray = new Transform[2];
        Rotate xRotate = new Rotate(0.0, Rotate.X_AXIS);
        objectArray[0] = xRotate;
        Rotate yRotate = new Rotate(0.0, Rotate.Y_AXIS);
        objectArray[1] = yRotate;
        allGroup.getTransforms().setAll(objectArray);
        xRotate.angleProperty().bind((ObservableValue)this.angleX);
        yRotate.angleProperty().bind((ObservableValue)this.angleY);
        subScene.setOnMousePressed(event -> {
            this.anchorX = event.getSceneX();
            this.anchorY = event.getSceneY();
            this.anchorAngleX = this.angleX.get();
            this.anchorAngleY = this.angleY.get();
        });
        subScene.setOnMouseDragged(event -> {
            this.angleX.set(this.anchorAngleX - (this.anchorY - event.getSceneY()));
            this.angleY.set(this.anchorAngleY + this.anchorX - event.getSceneX());
        });
        subCam.translateXProperty().bind((ObservableValue)this.xPos);
        subCam.translateYProperty().bind((ObservableValue)this.yPos);
        subCam.translateZProperty().bind((ObservableValue)this.zPos);
        subCam.scaleXProperty().bind((ObservableValue)this.sxPos);
        subCam.scaleYProperty().bind((ObservableValue)this.syPos);
        subCam.scaleZProperty().bind((ObservableValue)this.szPos);
        Object[] objectArray2 = new Transform[3];
        Rotate rxRotate = new Rotate(0.0, Rotate.X_AXIS);
        objectArray2[0] = rxRotate;
        Rotate ryRotate = new Rotate(0.0, Rotate.Y_AXIS);
        objectArray2[1] = ryRotate;
        Rotate rzRotate = new Rotate(0.0, Rotate.Z_AXIS);
        objectArray2[2] = rzRotate;
        subCam.getTransforms().setAll(objectArray2);
        rxRotate.angleProperty().bind((ObservableValue)this.rxPos);
        ryRotate.angleProperty().bind((ObservableValue)this.ryPos);
        rzRotate.angleProperty().bind((ObservableValue)this.rzPos);
        Object[] objectArray3 = new Transform[1];
        Rotate r_legRotate = new Rotate(0.0, Rotate.X_AXIS);
        objectArray3[0] = r_legRotate;
        dukeMesh[2].getTransforms().setAll(objectArray3);
        Object[] objectArray4 = new Transform[1];
        Rotate l_legRotate = new Rotate(0.0, Rotate.X_AXIS);
        objectArray4[0] = l_legRotate;
        dukeMesh[3].getTransforms().setAll(objectArray4);
        Object[] objectArray5 = new Transform[1];
        Rotate r_armRotate = new Rotate(0.0, Rotate.Z_AXIS);
        objectArray5[0] = r_armRotate;
        dukeMesh[4].getTransforms().setAll(objectArray5);
        Object[] objectArray6 = new Transform[1];
        Rotate l_armRotate = new Rotate(0.0, 0.0, -100.0, 0.0, Rotate.X_AXIS);
        objectArray6[0] = l_armRotate;
        dukeMesh[5].getTransforms().setAll(objectArray6);
        r_legRotate.angleProperty().bind((ObservableValue)this.angleWalk_r_X);
        l_legRotate.angleProperty().bind((ObservableValue)this.angleWalk_l_X);
        l_armRotate.angleProperty().bind((ObservableValue)this.angleWalk_l_arm);
        r_armRotate.angleProperty().bind((ObservableValue)this.angleWalk_r_arm);
        Object[] objectArray7 = new Transform[2];
        Rotate tyRotate = new Rotate(0.0, Rotate.Y_AXIS);
        objectArray7[0] = tyRotate;
        Rotate txRotate = new Rotate(0.0, Rotate.X_AXIS);
        objectArray7[1] = txRotate;
        dukeGroup.getTransforms().setAll(objectArray7);
        tyRotate.angleProperty().bind((ObservableValue)this.turnAngleY);
        txRotate.angleProperty().bind((ObservableValue)this.turnAngleX);
        this.dance();
        this.d_vx = -5.0;
        this.d_vz = -6.0;
        dukeGroup.setTranslateX(0.0);
        SecureRandom r = new SecureRandom();
        dukeGroup.setTranslateZ((double)(-r.nextInt(700)));
        this.turnAngleY.set(0.0);
        this.turnAngleX.set(0.0);
        this.azimuth = 0.0;
        this.previousHandledTime = 0L;
        this.anchorAngleX = 0.0;
        this.anchorAngleY = 0.0;
        this.angleX.set(0.0);
        this.angleY.set(0.0);
        this.angleWalk_r_X.set(0.0);
        this.angleWalk_l_X.set(0.0);
        this.angleWalk_l_arm.set(0.0);
        this.angleWalk_r_arm.set(0.0);
        this.xPos.set(0.0);
        this.yPos.set(0.0);
        this.zPos.set(-200.0);
        this.sxPos.set(1.0);
        this.syPos.set(1.0);
        this.szPos.set(1.0);
        this.rxPos.set(0.0);
        this.ryPos.set(0.0);
        this.rzPos.set(0.0);
        this.zPos.set(-1.0 * Math.cos(Math.toRadians(this.azimuth)) * 5500.0);
        this.yPos.set(-1.0 * Math.sin(Math.toRadians(this.elevationProperty.getValue())) * 5500.0);
        this.ryPos.set(-1.0 * this.azimuth);
        final double bord_left = boadGroup.getLayoutBounds().getMinX();
        final double bord_right = boadGroup.getLayoutBounds().getMaxX();
        final double bord_front = boadGroup.getLayoutBounds().getMinZ();
        final double bord_back = boadGroup.getLayoutBounds().getMaxZ();
        this.turnAngleY.set(Math.toDegrees(Math.atan(this.d_vz / this.d_vx)));
        this.walkMotion();
        this.walkTimer_g = new AnimationTimer(){

            public void handle(long now) {
                this.update(now);
            }

            private void update(long now) {
                if (About3DWindow.this.previousHandledTime == 0L) {
                    About3DWindow.this.previousHandledTime = now;
                    return;
                }
                About3DWindow.this.azimuth = About3DWindow.this.azimuth + About3DWindow.this.azimuthRateProperty.get() * (double)(now - About3DWindow.this.previousHandledTime) / 1.0E9;
                About3DWindow.this.previousHandledTime = now;
                About3DWindow.this.xPos.set(Math.sin(Math.toRadians(About3DWindow.this.azimuth)) * 5500.0);
                About3DWindow.this.zPos.set(-1.0 * Math.cos(Math.toRadians(About3DWindow.this.azimuth)) * 5500.0);
                About3DWindow.this.yPos.set(-1.0 * Math.sin(Math.toRadians(About3DWindow.this.elevationProperty.getValue())) * 5500.0);
                About3DWindow.this.ryPos.set(-1.0 * About3DWindow.this.azimuth);
                dukeGroup.setTranslateX(dukeGroup.getTranslateX() + About3DWindow.this.d_vx);
                dukeGroup.setTranslateZ(dukeGroup.getTranslateZ() + About3DWindow.this.d_vz);
                if (dukeGroup.getBoundsInParent().getMinX() < bord_left || dukeGroup.getBoundsInParent().getMaxX() > bord_right) {
                    About3DWindow.this.d_vx = -About3DWindow.this.d_vx;
                    this.turn();
                }
                if (dukeGroup.getBoundsInParent().getMinZ() < bord_front) {
                    About3DWindow.this.d_vz = -About3DWindow.this.d_vz;
                    this.turn();
                }
                if (dukeGroup.getBoundsInParent().getMaxZ() > bord_back) {
                    About3DWindow.this.d_vz = -About3DWindow.this.d_vz;
                    this.turn();
                }
            }

            private void turn() {
                double h = 0.0;
                if (About3DWindow.this.d_vz > 0.0) {
                    h = -180.0;
                }
                About3DWindow.this.turn_g = new Timeline(new KeyFrame[]{new KeyFrame(new Duration(250.0), new KeyValue[]{new KeyValue((WritableValue)About3DWindow.this.turnAngleY, (Object)(h + Math.toDegrees(Math.atan(About3DWindow.this.d_vz / About3DWindow.this.d_vx))), Interpolator.EASE_BOTH)})});
                About3DWindow.this.turn_g.play();
            }
        };
        this.walkTimer_g.start();
        aboutStage.setScene(scene);
        aboutStage.setTitle("Search 2012 ver.1.0");
        aboutStage.setResizable(false);
        aboutStage.show();
    }

    private void dance() {
        this.audioSpectrumListener = this;
        this.mp_bgm = new MediaPlayer(this.bgm);
        this.mp_bgm.setAudioSpectrumListener(this.audioSpectrumListener);
        this.mp_bgm.setAudioSpectrumInterval(0.01);
        this.mp_bgm.setAudioSpectrumNumBands(8);
        this.mp_bgm.setVolume(0.9);
        this.mp_bgm.setAutoPlay(true);
        this.mp_bgm.setCycleCount(-1);
    }

    public void spectrumDataUpdate(double timestamp, double duration, float[] magnitudes, float[] phases) {
        IntStream.range(0, magnitudes.length).forEach(i -> {
            this.backMesh[i].setScaleX(((double)magnitudes[i] + 60.01) * 0.06 + 1.0);
            this.backMesh[i].setScaleY(((double)magnitudes[i] + 60.01) * 0.06 + 1.0);
            this.backMesh[i].setScaleZ(((double)magnitudes[i] + 60.01) * 0.06 + 1.0);
        });
    }

    private void walkMotion() {
        this.dukeAnim = new Timeline(new KeyFrame[]{new KeyFrame(new Duration(300.0), new KeyValue[]{new KeyValue((WritableValue)this.angleWalk_r_X, (Object)-25), new KeyValue((WritableValue)this.angleWalk_l_X, (Object)25), new KeyValue((WritableValue)this.angleWalk_l_arm, (Object)-20), new KeyValue((WritableValue)this.angleWalk_r_arm, (Object)12, Interpolator.EASE_BOTH)}), new KeyFrame(new Duration(600.0), new KeyValue[]{new KeyValue((WritableValue)this.angleWalk_r_X, (Object)0), new KeyValue((WritableValue)this.angleWalk_l_X, (Object)0), new KeyValue((WritableValue)this.angleWalk_l_arm, (Object)0), new KeyValue((WritableValue)this.angleWalk_r_arm, (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(new Duration(900.0), new KeyValue[]{new KeyValue((WritableValue)this.angleWalk_r_X, (Object)25), new KeyValue((WritableValue)this.angleWalk_l_X, (Object)-25), new KeyValue((WritableValue)this.angleWalk_l_arm, (Object)20), new KeyValue((WritableValue)this.angleWalk_r_arm, (Object)12, Interpolator.EASE_BOTH)}), new KeyFrame(new Duration(1200.0), new KeyValue[]{new KeyValue((WritableValue)this.angleWalk_r_X, (Object)0), new KeyValue((WritableValue)this.angleWalk_l_X, (Object)0), new KeyValue((WritableValue)this.angleWalk_l_arm, (Object)0), new KeyValue((WritableValue)this.angleWalk_r_arm, (Object)0, Interpolator.EASE_BOTH)})});
        this.dukeAnim.setCycleCount(-1);
        this.dukeAnim.play();
    }

    private void changeForegroundOnHoverUsingBinding(Node node) {
        node.styleProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)node.hoverProperty()).then((ObservableStringValue)new SimpleStringProperty("-fx-font:  bold 24pt 'serif'; -fx-text-fill: lime; -fx-background-color:TRANSPARENT;-fx-background-color: white")).otherwise((ObservableStringValue)new SimpleStringProperty("-fx-font:  bold 24pt 'serif'; -fx-text-fill: hotpink; -fx-background-color:TRANSPARENT;-fx-background-color: white")));
    }

    public void changeBackgroundMouseEventUsingEvents(Node node) {
        node.setStyle("-fx-text-fill: deepskyblue; -fx-font-size: 14pt;  -fx-background-color:TRANSPARENT;-fx-background-color: white");
        node.setOnMousePressed(mouseEvent -> node.setStyle("-fx-text-fill: lime; -fx-font-size: 14pt;  -fx-background-color:TRANSPARENT;-fx-background-color: white"));
        node.setOnMouseReleased(mouseEvent -> node.setStyle("-fx-text-fill: deepskyblue; -fx-font-size: 14pt;  -fx-background-color:TRANSPARENT;-fx-background-color: white"));
        node.setOnMouseEntered(mouseEvent -> node.setStyle("-fx-text-fill: magenta; -fx-font-size: 14pt;  -fx-background-color:TRANSPARENT;-fx-background-color: white"));
        node.setOnMouseExited(mouseEvent -> node.setStyle("-fx-text-fill: deepskyblue; -fx-font-size: 14pt;  -fx-background-color:TRANSPARENT;-fx-background-color: white"));
    }

    private void stopLine() {
        if (this.mp_bgm != null) {
            this.mp_bgm.stop();
        }
        if (this.dukeAnim != null) {
            this.dukeAnim.stop();
        }
        if (this.walkTimer_g != null) {
            this.walkTimer_g.stop();
        }
        if (this.turn_g != null) {
            this.turn_g.stop();
        }
    }
}

