/*
 * Decompiled with CFR 0.152.
 */
package jp.yucchi.search2014;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.ResourceBundle;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.layout.AnchorPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import jp.yucchi.search2014.About3DWindow;
import jp.yucchi.search2014.AlertController;
import jp.yucchi.search2014.BrowserController;
import jp.yucchi.search2014.Finder;
import jp.yucchi.search2014.SearchFileController;

public class FXMLDocumentController
implements Initializable {
    @FXML
    private AnchorPane mainAnchor;
    @FXML
    private MenuBar menuBar;
    @FXML
    private MenuItem file;
    @FXML
    private MenuItem edit;
    @FXML
    private MenuItem help;
    @FXML
    private MenuItem exit;
    @FXML
    private CheckMenuItem caseSensitive;
    @FXML
    private CheckMenuItem subDirectories;
    @FXML
    private CheckMenuItem permissionError;
    @FXML
    private MenuItem usage;
    @FXML
    private MenuItem about;
    @FXML
    private Label keyWordLabel;
    @FXML
    private TextField keyWordField;
    @FXML
    private Button searchButton;
    @FXML
    private Label searchAreaLabel;
    @FXML
    private TextField searchAreaField;
    @FXML
    private Button searchAreaButton;
    @FXML
    private Label fileTypeLabel;
    @FXML
    private ComboBox<String> fileTypeCombo;
    @FXML
    private Button clearButton;
    @FXML
    private Button cancelButton;
    @FXML
    private TabPane resultTabpane;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private Label progressLabel;
    private DirectoryChooser directoryChooser;
    private boolean _caseSensitive = true;
    private boolean _subDirectories = true;
    private boolean _permissionError;
    private String keyWord;
    private String extension;
    private Tab resaultListTab;
    private ExecutorService service;
    private final BlockingQueue<String> queue = new LinkedBlockingQueue<String>();
    private Timeline timer;
    private Task<Void> task;
    private String tabSearchWord;
    private boolean tabSearchCaseSensitive;

    @FXML
    public void handleExit(ActionEvent event) {
        if (this.service != null && !this.service.isShutdown()) {
            this.service.shutdownNow();
        }
        Platform.exit();
        System.exit(-1);
    }

    @FXML
    public void handleCaseSensitive(ActionEvent event) {
        this._caseSensitive = this.caseSensitive.isSelected();
    }

    @FXML
    public void handleSubDirectories(ActionEvent event) {
        this._subDirectories = this.subDirectories.isSelected();
    }

    @FXML
    public void handlePermissionError(ActionEvent event) {
        this._permissionError = this.permissionError.isSelected();
    }

    @FXML
    public void handleUsage(ActionEvent event) {
        Platform.runLater(() -> {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("Browser.fxml"));
            try {
                loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(FXMLDocumentController.class.getName()).log(Level.SEVERE, null, ex);
            }
            BrowserController controller = (BrowserController)loader.getController();
            Parent root = (Parent)loader.getRoot();
            Scene scene = new Scene(root);
            scene.getStylesheets().add((Object)this.getClass().getResource("browser.css").toExternalForm());
            Stage browseWindow = new Stage(StageStyle.DECORATED);
            browseWindow.setScene(scene);
            browseWindow.initOwner(null);
            browseWindow.initModality(Modality.NONE);
            browseWindow.setResizable(true);
            browseWindow.setTitle("Help <Usage>");
            browseWindow.show();
        });
    }

    @FXML
    public void handleAbout(ActionEvent event) {
        new About3DWindow(this.mainAnchor);
    }

    @FXML
    public void handleSearch(ActionEvent event) {
        if ((this.keyWordField.getText() == null || this.keyWordField.getText().isEmpty() || this.keyWordField.getText().length() == 0) && (this.searchAreaField.getText() == null || this.searchAreaField.getText().isEmpty() || this.searchAreaField.getText().length() == 0)) {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("Alert.fxml"));
            try {
                loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(FXMLDocumentController.class.getName()).log(Level.SEVERE, null, ex);
            }
            String message = "";
            String details = "Please input a keyword and a location.";
            AlertController controller = (AlertController)loader.getController();
            controller.setAlert(message, details);
            Parent root = (Parent)loader.getRoot();
            Scene scene = new Scene(root);
            scene.getStylesheets().add((Object)this.getClass().getResource("alert.css").toExternalForm());
            Stage alertDialog = new Stage(StageStyle.UTILITY);
            alertDialog.setScene(scene);
            alertDialog.initOwner(this.mainAnchor.getScene().getWindow());
            alertDialog.initModality(Modality.WINDOW_MODAL);
            alertDialog.setResizable(false);
            alertDialog.setTitle("Alert");
            alertDialog.show();
            controller.shakeWindow(alertDialog);
            return;
        }
        if (this.keyWordField.getText() == null || this.keyWordField.getText().isEmpty() || this.keyWordField.getText().length() == 0) {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("Alert.fxml"));
            try {
                loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(FXMLDocumentController.class.getName()).log(Level.SEVERE, null, ex);
            }
            String message = "";
            String details = "Please input a keyword.";
            AlertController controller = (AlertController)loader.getController();
            controller.setAlert(message, details);
            Parent root = (Parent)loader.getRoot();
            Scene scene = new Scene(root);
            scene.getStylesheets().add((Object)this.getClass().getResource("alert.css").toExternalForm());
            Stage alertDialog = new Stage(StageStyle.UTILITY);
            alertDialog.setScene(scene);
            alertDialog.initOwner(this.mainAnchor.getScene().getWindow());
            alertDialog.initModality(Modality.WINDOW_MODAL);
            alertDialog.setResizable(false);
            alertDialog.setTitle("Alert");
            alertDialog.show();
            controller.shakeWindow(alertDialog);
            return;
        }
        if (this.searchAreaField.getText() == null || this.searchAreaField.getText().isEmpty() || this.searchAreaField.getText().length() == 0) {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("Alert.fxml"));
            try {
                loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(FXMLDocumentController.class.getName()).log(Level.SEVERE, null, ex);
            }
            String message = "";
            String details = "Please input a Location.";
            AlertController controller = (AlertController)loader.getController();
            controller.setAlert(message, details);
            Parent root = (Parent)loader.getRoot();
            Scene scene = new Scene(root);
            scene.getStylesheets().add((Object)this.getClass().getResource("alert.css").toExternalForm());
            Stage alertDialog = new Stage(StageStyle.UTILITY);
            alertDialog.setScene(scene);
            alertDialog.initOwner(this.mainAnchor.getScene().getWindow());
            alertDialog.initModality(Modality.WINDOW_MODAL);
            alertDialog.setResizable(false);
            alertDialog.setTitle("Alert");
            alertDialog.show();
            controller.shakeWindow(alertDialog);
            return;
        }
        if (this.extension == null) {
            this.extension = "*";
        }
        this.keyWord = this.keyWordField.getText();
        this.service = Executors.newSingleThreadExecutor();
        this.searchButton.setText("Searching...");
        this.searchButton.setDisable(true);
        this.searchAreaButton.setDisable(true);
        this.clearButton.setDisable(true);
        this.fileTypeCombo.setDisable(true);
        this.keyWordField.setEditable(false);
        this.searchAreaField.setEditable(false);
        this.caseSensitive.setDisable(true);
        this.subDirectories.setDisable(true);
        this.permissionError.setDisable(true);
        this.usage.setDisable(true);
        this.about.setDisable(true);
        this.cancelButton.setDisable(false);
        this.progressBar.setVisible(true);
        this.progressLabel.setVisible(true);
        this.resaultListTab = new Tab(this.keyWordField.getText());
        this.resaultListTab.setUserData((Object)this._caseSensitive);
        this.resultTabpane.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
        this.resaultListTab.setClosable(false);
        this.resultTabpane.getTabs().add((Object)this.resaultListTab);
        this.resultTabpane.getSelectionModel().select((Object)this.resaultListTab);
        ListView resultList = new ListView();
        MultipleSelectionModel model = resultList.getSelectionModel();
        model.selectedItemProperty().addListener((property, oldValue, newValue) -> {
            if (newValue != null) {
                this.showHighlightedWindow((String)newValue, this.tabSearchWord, this.tabSearchCaseSensitive);
            }
        });
        ObservableList result = FXCollections.observableArrayList();
        this.resaultListTab.setContent((Node)resultList);
        resultList.setItems(result);
        this.task = new Task<Void>(){

            protected Void call() {
                Path searchDir = Paths.get(FXMLDocumentController.this.searchAreaField.getText(), new String[0]);
                String pattern = FXMLDocumentController.this.extension;
                EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
                Finder finder = new Finder(pattern, FXMLDocumentController.this.queue, FXMLDocumentController.this.keyWord, FXMLDocumentController.this._caseSensitive, FXMLDocumentController.this._permissionError, FXMLDocumentController.this.mainAnchor);
                try {
                    if (FXMLDocumentController.this._subDirectories) {
                        Files.walkFileTree(searchDir, opts, Integer.MAX_VALUE, finder);
                    } else {
                        Files.walkFileTree(searchDir, opts, 1, finder);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(FXMLDocumentController.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }
        };
        this.task.setOnSucceeded(t -> {
            if (!this.service.isShutdown()) {
                this.service.shutdownNow();
            }
        });
        this.task.setOnFailed(t -> Platform.runLater(() -> {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("Alert.fxml"));
            try {
                loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(FXMLDocumentController.class.getName()).log(Level.SEVERE, null, ex);
            }
            String message = "Search processing error.";
            String details = t.getSource().getException().getMessage();
            AlertController controller = (AlertController)loader.getController();
            controller.setAlert(message, details);
            Parent root = (Parent)loader.getRoot();
            Scene scene = new Scene(root);
            scene.getStylesheets().add((Object)this.getClass().getResource("alert.css").toExternalForm());
            Stage alertDialog = new Stage(StageStyle.UTILITY);
            alertDialog.setScene(scene);
            alertDialog.initOwner(this.mainAnchor.getScene().getWindow());
            alertDialog.initModality(Modality.WINDOW_MODAL);
            alertDialog.setResizable(false);
            alertDialog.setTitle("Search processing error.");
            alertDialog.show();
            controller.randomShakeWindow(alertDialog);
        }));
        this.service.submit((Runnable)this.task);
        this.timer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)10.0), e -> {
            while (!this.queue.isEmpty()) {
                try {
                    result.add((Object)this.queue.take());
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FXMLDocumentController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.task.isDone() || this.task.isCancelled()) {
                this.timer.stop();
                this.searchButton.setDisable(false);
                this.searchButton.setText("Search");
                this.searchAreaButton.setDisable(false);
                this.cancelButton.setDisable(true);
                this.clearButton.setDisable(false);
                this.fileTypeCombo.setDisable(false);
                this.keyWordField.setEditable(true);
                this.searchAreaField.setEditable(true);
                this.caseSensitive.setDisable(false);
                this.subDirectories.setDisable(false);
                this.permissionError.setDisable(false);
                this.usage.setDisable(false);
                this.about.setDisable(false);
                this.progressBar.setVisible(false);
                this.progressLabel.setVisible(false);
                this.resaultListTab.setClosable(true);
                if (!this.service.isShutdown()) {
                    this.service.shutdownNow();
                }
            }
        }, new KeyValue[0])});
        this.timer.setCycleCount(-1);
        this.timer.play();
    }

    @FXML
    public void handleCancel(ActionEvent event) {
        if (this.task.isRunning()) {
            this.task.cancel();
        }
    }

    @FXML
    public void handleBrowse(ActionEvent event) {
        File selectedDirectory = this.directoryChooser.showDialog(null);
        if (selectedDirectory != null) {
            this.searchAreaField.setText(selectedDirectory.getAbsolutePath());
        }
    }

    @FXML
    public void handleFileTypeCombo(ActionEvent event) {
        this.extension = (String)this.fileTypeCombo.getValue();
    }

    @FXML
    public void handleClear(ActionEvent event) {
        this.keyWordField.setText(null);
        this.searchAreaField.setText(null);
        this.fileTypeCombo.getEditor().clear();
        this.fileTypeCombo.getEditor().setText(null);
        this.fileTypeCombo.getSelectionModel().clearSelection();
        this.extension = null;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.progressBar.setVisible(false);
        this.progressLabel.setVisible(false);
        this.directoryChooser = new DirectoryChooser();
        this.directoryChooser.setTitle("Please select a search location.");
        ObservableList extensions = FXCollections.observableArrayList((Object[])new String[]{"java", "fxml", "xml", "c", "c++", "txt", "html", "*"});
        this.fileTypeCombo.setItems(extensions);
        this.cancelButton.setDisable(true);
        this.resultTabpane.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.tabSearchCaseSensitive = (Boolean)newValue.getUserData();
                this.tabSearchWord = newValue.getText();
            }
        });
    }

    void setStage(Stage stage) {
        stage.setOnCloseRequest(we -> {
            if (this.service != null && !this.service.isShutdown()) {
                this.service.shutdownNow();
            }
            Platform.exit();
            System.exit(-1);
        });
    }

    private void showHighlightedWindow(String location, String keyWord, boolean _caseSensitive) {
        System.out.println("location: " + location + "\n" + "keyWord: " + keyWord + "\n" + "_caseSensitive: " + _caseSensitive);
        Platform.runLater(() -> {
            String text = null;
            try {
                text = Files.lines(Paths.get(location, new String[0])).reduce(new StringBuilder(), (builder, s) -> {
                    builder.append((String)s);
                    builder.append(System.getProperty("line.separator"));
                    return builder;
                }, (left, right) -> left.append((CharSequence)right)).toString();
            }
            catch (IOException ex) {
                Logger.getLogger(FXMLDocumentController.class.getName()).log(Level.SEVERE, null, ex);
            }
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("SearchFileController.fxml"));
            try {
                loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(FXMLDocumentController.class.getName()).log(Level.SEVERE, null, ex);
            }
            Parent root = (Parent)loader.getRoot();
            Scene scene = new Scene(root);
            scene.getStylesheets().add((Object)this.getClass().getResource("result.css").toExternalForm());
            Stage searchFileWindow = new Stage(StageStyle.DECORATED);
            searchFileWindow.setScene(scene);
            searchFileWindow.initOwner(null);
            searchFileWindow.initModality(Modality.NONE);
            searchFileWindow.setResizable(true);
            searchFileWindow.setTitle(keyWord + " : " + location);
            searchFileWindow.setX(5.0);
            searchFileWindow.setY(5.0);
            Image myIcon = new Image(this.getClass().getResource("icon/sakura_2.gif").toExternalForm());
            searchFileWindow.getIcons().add((Object)myIcon);
            searchFileWindow.show();
            SearchFileController controller = (SearchFileController)loader.getController();
            controller.textMake(text, keyWord, _caseSensitive);
        });
    }
}

