/*
 * Decompiled with CFR 0.152.
 */
package jp.yucchi.search2014;

import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.util.Duration;

public class AlertController
implements Initializable {
    @FXML
    private ImageView imageView;
    @FXML
    private Label messageLabel;
    @FXML
    private Label detailsLabel;
    @FXML
    private HBox actionParent;
    @FXML
    private HBox okParent;
    @FXML
    private Button okButton;

    public void initialize(URL url, ResourceBundle rb) {
    }

    void setAlert(String message, String details) {
        this.messageLabel.setText(message);
        this.detailsLabel.setText(details);
        if (details != null && details.equals("Location is incorrect.")) {
            this.imageView.setImage(new Image(this.getClass().getResourceAsStream("icon/Error.png")));
        }
        if (message.length() > 0) {
            this.imageView.setImage(new Image(this.getClass().getResourceAsStream("icon/Error.png")));
        }
    }

    @FXML
    private void handleBtnOkAction(ActionEvent event) {
        this.detailsLabel.getScene().getWindow().hide();
    }

    void shakeWindow(final Stage alertDialog) {
        Timeline shakeTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.03), (EventHandler)new EventHandler<ActionEvent>(){
            boolean state = true;
            private final int SHAKE_DISTANCE = 90;
            int modulation = 2;

            public void handle(ActionEvent ae) {
                if (this.state) {
                    alertDialog.setX(alertDialog.getX() + (double)(90 / this.modulation++));
                } else {
                    alertDialog.setX(alertDialog.getX() - (double)(90 / this.modulation++));
                }
                this.state = !this.state;
            }
        }, new KeyValue[0])});
        shakeTimeline.setCycleCount(16);
        shakeTimeline.setAutoReverse(false);
        shakeTimeline.play();
    }

    void randomShakeWindow(final Stage alertDialog) {
        SecureRandom rx = null;
        try {
            rx = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(AlertController.class.getName()).log(Level.SEVERE, null, ex);
        }
        SecureRandom ry = null;
        try {
            ry = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(AlertController.class.getName()).log(Level.SEVERE, null, ex);
        }
        int x = rx.nextInt(400) - 200;
        int y = ry.nextInt(400) - 200;
        alertDialog.setX(alertDialog.getX() + (double)x);
        alertDialog.setY(alertDialog.getY() + (double)y);
        Timeline shakeTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.03), (EventHandler)new EventHandler<ActionEvent>(){
            boolean state = true;
            private final int SHAKE_DISTANCE = 90;
            int modulation = 2;

            public void handle(ActionEvent ae) {
                if (this.state) {
                    alertDialog.setX(alertDialog.getX() + (double)(90 / this.modulation++));
                } else {
                    alertDialog.setX(alertDialog.getX() - (double)(90 / this.modulation++));
                }
                this.state = !this.state;
            }
        }, new KeyValue[0])});
        shakeTimeline.setCycleCount(16);
        shakeTimeline.setAutoReverse(false);
        shakeTimeline.play();
    }
}

