/*
 * Decompiled with CFR 0.152.
 */
package jp.yucchi.search2014;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import jp.yucchi.search2014.AlertController;
import jp.yucchi.search2014.FXMLDocumentController;

public class BrowserController
implements Initializable {
    @FXML
    private AnchorPane mainAnchor;
    @FXML
    private AnchorPane browseAnchor;
    @FXML
    private ImageView backImage;
    @FXML
    private ImageView forwardImage;
    @FXML
    private TextField urlField;
    @FXML
    private Button go;
    @FXML
    private WebView webView;
    @FXML
    private ProgressIndicator progressIndicator;
    private WebEngine webEngine;
    private WebHistory webHistory;

    @FXML
    private void load(ActionEvent event) {
        String url = this.urlField.getText();
        this.webEngine.load(url);
    }

    @FXML
    private void goUrl(ActionEvent event) {
        String url = this.urlField.getText();
        this.webEngine.load(url);
    }

    @FXML
    public void backward(MouseEvent event) {
        if (this.webHistory.getCurrentIndex() > 0) {
            this.webHistory.go(-1);
        }
    }

    @FXML
    public void forward(MouseEvent event) {
        if (this.webHistory.getCurrentIndex() < this.webHistory.getEntries().size()) {
            this.webHistory.go(1);
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.progressIndicator.setVisible(true);
        this.webEngine = this.webView.getEngine();
        this.webHistory = this.webEngine.getHistory();
        this.webEngine.load("http://yucchi-ja.com/yucchi_nanosystems/search2014/usage/usage.html");
        this.webEngine.setOnAlert(event -> Platform.runLater(() -> {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("Alert.fxml"));
            try {
                loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(FXMLDocumentController.class.getName()).log(Level.SEVERE, null, ex);
            }
            String message = "JavaScript Alert";
            String details = (String)event.getData();
            AlertController controller = (AlertController)loader.getController();
            controller.setAlert(message, details);
            Parent root = (Parent)loader.getRoot();
            Scene scene = new Scene(root);
            scene.getStylesheets().add((Object)this.getClass().getResource("alert.css").toExternalForm());
            Stage alertDialog = new Stage(StageStyle.UTILITY);
            alertDialog.setScene(scene);
            alertDialog.initOwner(this.mainAnchor.getScene().getWindow());
            alertDialog.initModality(Modality.WINDOW_MODAL);
            alertDialog.setResizable(false);
            alertDialog.setTitle("JavaScript Alert");
            alertDialog.show();
            controller.randomShakeWindow(alertDialog);
        }));
        Worker worker = this.webEngine.getLoadWorker();
        worker.stateProperty().addListener((value, oldState, newState) -> {
            if (newState == Worker.State.SCHEDULED) {
                this.progressIndicator.setVisible(true);
            }
            if (newState == Worker.State.SUCCEEDED) {
                this.progressIndicator.setVisible(false);
                this.urlField.setText(this.webEngine.getLocation());
            } else if (newState == Worker.State.FAILED) {
                this.progressIndicator.setVisible(false);
                this.webEngine.load("http://yucchi.jp/yucchi_nanosystems/search2014/usage/usage.html" + this.urlField.getText());
            }
        });
    }
}

