/*
 * Decompiled with CFR 0.152.
 */
package jp.yucchi.search2014;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.MalformedInputException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import jp.yucchi.search2014.AlertController;
import jp.yucchi.search2014.FXMLDocumentController;

class Finder
implements FileVisitor<Path> {
    private final PathMatcher matcher;
    private final BlockingQueue<String> queue;
    private final String keyWord;
    private final boolean _caseSensitive;
    private final boolean _permissionError;
    private final AnchorPane mainAnchor;
    private Stage errorDialog;

    Finder(String pattern, BlockingQueue<String> queue, String keyWord, boolean _caseSensitive, boolean _permissionError, AnchorPane mainAnchor) {
        this.matcher = FileSystems.getDefault().getPathMatcher("glob:*." + pattern);
        this.queue = queue;
        this.keyWord = keyWord;
        this._caseSensitive = _caseSensitive;
        this._permissionError = _permissionError;
        this.mainAnchor = mainAnchor;
    }

    void find(Path file) {
        if (this.matcher.matches(file.getFileName()) && this.searchFile(file, this.keyWord, this._caseSensitive)) {
            this.queue.offer(file.toString());
        }
    }

    private boolean searchFile(Path file, String keyWord, boolean _caseSensitive) {
        try {
            FileInputStream fis = new FileInputStream(file.toFile());
            FileChannel channel = fis.getChannel();
            int fileLength = (int)channel.size();
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileLength);
            Charset charset = Charset.forName(System.getProperty("file.encoding"));
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer charBuffer = decoder.decode(buffer);
            Pattern pattern = Pattern.compile(keyWord, 2);
            Pattern strictPattern = Pattern.compile(keyWord);
            if (_caseSensitive) {
                Matcher _matcher = pattern.matcher(charBuffer);
                return _matcher.find();
            }
            Matcher strictMatcher = strictPattern.matcher(charBuffer);
            return strictMatcher.find();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Finder.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchFileException ex) {
            Logger.getLogger(Finder.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MalformedInputException ex) {
            Logger.getLogger(Finder.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Finder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        this.find(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        if (exc.getClass().toString().equals("class java.nio.file.NoSuchFileException")) {
            Platform.runLater(() -> {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("Alert.fxml"));
                try {
                    loader.load();
                }
                catch (IOException ex) {
                    Logger.getLogger(FXMLDocumentController.class.getName()).log(Level.SEVERE, null, ex);
                }
                String message = "";
                String details = "Location is incorrect.";
                AlertController controller = (AlertController)loader.getController();
                controller.setAlert(message, details);
                Parent root = (Parent)loader.getRoot();
                Scene scene = new Scene(root);
                scene.getStylesheets().add((Object)this.getClass().getResource("alert.css").toExternalForm());
                Stage alertDialog = new Stage(StageStyle.UTILITY);
                alertDialog.setScene(scene);
                alertDialog.initOwner(this.mainAnchor.getScene().getWindow());
                alertDialog.initModality(Modality.WINDOW_MODAL);
                alertDialog.setResizable(false);
                alertDialog.setTitle("Error");
                alertDialog.show();
                controller.shakeWindow(alertDialog);
            });
        }
        if (exc.getClass().toString().equals("class java.nio.file.AccessDeniedException") && this._permissionError) {
            Platform.runLater(() -> {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("Alert.fxml"));
                try {
                    loader.load();
                }
                catch (IOException ex) {
                    Logger.getLogger(FXMLDocumentController.class.getName()).log(Level.SEVERE, null, ex);
                }
                String message = "AccessDeniedException";
                String details = exc.getMessage();
                AlertController controller = (AlertController)loader.getController();
                controller.setAlert(message, details);
                Parent root = (Parent)loader.getRoot();
                Scene scene = new Scene(root);
                scene.getStylesheets().add((Object)this.getClass().getResource("alert.css").toExternalForm());
                Stage alertDialog = new Stage(StageStyle.UTILITY);
                alertDialog.setScene(scene);
                alertDialog.initOwner(null);
                alertDialog.initModality(Modality.NONE);
                alertDialog.setResizable(false);
                alertDialog.setTitle("Error");
                alertDialog.show();
                controller.randomShakeWindow(alertDialog);
            });
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

