/*
 * Decompiled with CFR 0.152.
 */
package coreTest2;

import coreTest2.CalculationCall;
import coreTest2.CoreTest2AboutBox;
import coreTest2.CoreTest2App;
import coreTest2.MinMaxValidator;
import coreTest2.RequiredValidator;
import coreTest2.setUp;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.BindingListener;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.PropertyStateEvent;
import sun.tools.jar.Main;

public class CoreTest2View
extends FrameView {
    private CallTaskTask ctt = null;
    private ExecutorService ex;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private MinMaxValidator<Integer> minMaxValidator1;
    private MinMaxValidator<Integer> minMaxValidator2;
    private JProgressBar progressBar;
    private RequiredValidator requiredValidator;
    private JLabel resultLabel;
    private setUp setUp;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private BindingGroup bindingGroup;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public CoreTest2View(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        this.setInitialValue();
        this.bindingGroup.addBindingListener((BindingListener)new BindingChecker());
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoreTest2View.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoreTest2View.this.busyIconIndex = (CoreTest2View.this.busyIconIndex + 1) % CoreTest2View.this.busyIcons.length;
                CoreTest2View.this.statusAnimationLabel.setIcon(CoreTest2View.this.busyIcons[CoreTest2View.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!CoreTest2View.this.busyIconTimer.isRunning()) {
                        CoreTest2View.this.statusAnimationLabel.setIcon(CoreTest2View.this.busyIcons[0]);
                        CoreTest2View.this.busyIconIndex = 0;
                        CoreTest2View.this.busyIconTimer.start();
                    }
                    CoreTest2View.this.progressBar.setVisible(true);
                    CoreTest2View.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    CoreTest2View.this.busyIconTimer.stop();
                    CoreTest2View.this.statusAnimationLabel.setIcon(CoreTest2View.this.idleIcon);
                    CoreTest2View.this.progressBar.setVisible(false);
                    CoreTest2View.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    CoreTest2View.this.statusMessageLabel.setText(text == null ? "" : text);
                    CoreTest2View.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    CoreTest2View.this.progressBar.setVisible(true);
                    CoreTest2View.this.progressBar.setIndeterminate(false);
                    CoreTest2View.this.progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = CoreTest2App.getApplication().getMainFrame();
            this.aboutBox = new CoreTest2AboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        CoreTest2App.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.mainPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jTextField1 = new LimitedField(6);
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel1 = new JLabel();
        this.jButton3 = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextField2 = new LimitedField(3);
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jPanel3 = new JPanel();
        this.resultLabel = new JLabel();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.setUp = new setUp();
        this.requiredValidator = new RequiredValidator();
        this.minMaxValidator1 = new MinMaxValidator();
        this.minMaxValidator2 = new MinMaxValidator();
        this.mainPanel.setName("mainPanel");
        this.jPanel1.setName("jPanel1");
        this.jTextField1.setHorizontalAlignment(4);
        ResourceMap resourceMap = Application.getInstance(CoreTest2App.class).getContext().getResourceMap(CoreTest2View.class);
        this.jTextField1.setToolTipText(resourceMap.getString("jTextField1.toolTipText", new Object[0]));
        this.jTextField1.setName("jTextField1");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.setUp, (Property)ELProperty.create((String)"${size}"), (Object)this.jTextField1, (Property)BeanProperty.create((String)"text"), (String)"setUp.size");
        binding.setValidator(this.minMaxValidator1);
        this.bindingGroup.addBinding((Binding)binding);
        ApplicationActionMap actionMap = Application.getInstance(CoreTest2App.class).getContext().getActionMap(CoreTest2View.class, this);
        this.jButton1.setAction(actionMap.get("callTask"));
        this.jButton1.setName("jButton1");
        this.jButton2.setAction(actionMap.get("stopCall"));
        this.jButton2.setName("jButton2");
        this.jLabel1.setFont(resourceMap.getFont("jLabel1.font"));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jButton3.setAction(actionMap.get("termination"));
        this.jButton3.setName("jButton3");
        this.jLabel2.setFont(new Font("\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", 1, 12));
        this.jLabel2.setForeground(resourceMap.getColor("jLabel2.foreground"));
        this.jLabel2.setHorizontalAlignment(2);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jTextField2.setHorizontalAlignment(4);
        this.jTextField2.setToolTipText(resourceMap.getString("jTextField2.toolTipText", new Object[0]));
        this.jTextField2.setName("jTextField2");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.setUp, (Property)ELProperty.create((String)"${pool}"), (Object)this.jTextField2, (Property)BeanProperty.create((String)"text"), (String)"setUp.pool");
        binding.setValidator(this.minMaxValidator2);
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel5.setFont(resourceMap.getFont("jLabel5.font"));
        this.jLabel5.setForeground(resourceMap.getColor("jLabel5.foreground"));
        this.jLabel5.setHorizontalAlignment(2);
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.jButton2.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 105, -2).addGap(115, 115, 115).addComponent(this.jLabel2, -1, 282, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton1, -1, 105, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -1, 105, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3, -1, 278, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4, -1, 105, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField1, -2, 94, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextField2, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -1, 282, Short.MAX_VALUE))))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButton1, this.jButton2, this.jLabel1, this.jLabel4, this.jTextField1, this.jTextField2);
        jPanel1Layout.linkSize(0, this.jLabel2, this.jLabel5);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextField1, -2, -1, -2).addGap(27, 27, 27)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jLabel5)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1, -2, 19, -2).addComponent(this.jButton2).addComponent(this.jButton3)).addContainerGap()));
        jPanel1Layout.linkSize(1, this.jButton1, this.jButton2, this.jButton3, this.jLabel1, this.jLabel2, this.jLabel4, this.jLabel5, this.jTextField1, this.jTextField2);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel2.border.title", new Object[0]), 0, 0, new Font("MS UI Gothic", 0, 12), resourceMap.getColor("jPanel2.border.titleColor")));
        this.jPanel2.setName("jPanel2");
        this.jScrollPane1.setName("jScrollPane1");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setName("jTextArea1");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 490, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel3.border.title", new Object[0]), 0, 0, new Font("MS UI Gothic", 0, 12), resourceMap.getColor("jPanel3.border.titleColor")));
        this.jPanel3.setName("jPanel3");
        this.resultLabel.setFont(resourceMap.getFont("resultLabel.font"));
        this.resultLabel.setForeground(resourceMap.getColor("resultLabel.foreground"));
        this.resultLabel.setHorizontalAlignment(0);
        this.resultLabel.setIcon(resourceMap.getIcon("resultLabel.icon"));
        this.resultLabel.setText(resourceMap.getString("resultLabel.text", new Object[0]));
        this.resultLabel.setName("resultLabel");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.resultLabel, -1, 490, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resultLabel, -1, -1, Short.MAX_VALUE));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel3, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setText(resourceMap.getString("exitMenuItem.text", new Object[0]));
        exitMenuItem.setToolTipText(resourceMap.getString("exitMenuItem.toolTipText", new Object[0]));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 550, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 375, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.minMaxValidator1.setMax(99999);
        this.minMaxValidator1.setMin(1);
        this.minMaxValidator2.setMax(160);
        this.minMaxValidator2.setMin(1);
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
        this.bindingGroup.bind();
    }

    @Action
    public Task callTask() {
        ResourceMap resourceMap = Application.getInstance(CoreTest2App.class).getContext().getResourceMap(CoreTest2View.class);
        this.resultLabel.setText(resourceMap.getString("result.start", new Object[0]));
        this.resultLabel.setIcon(resourceMap.getIcon("startIcon"));
        this.jTextArea1.setText("");
        this.jButton1.setText("\u5b9f\u884c\u4e2d");
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(true);
        return new CallTaskTask(this.getApplication());
    }

    @Action
    public void stopCall() {
        if (this.ctt != null && !this.ctt.isDone()) {
            this.ctt.cancel(true);
        }
        this.ctt = null;
        this.jTextArea1.append("\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u307e\u3057\u305f\n");
    }

    @Action
    public void termination() {
        Toolkit.getDefaultToolkit().beep();
        System.exit(1);
    }

    void setInitialValue() {
        ResourceMap resourceMap = Application.getInstance(CoreTest2App.class).getContext().getResourceMap(CoreTest2View.class);
        this.jTextField1.setText(resourceMap.getString("size.default", new Object[0]));
        this.jTextField2.setText(resourceMap.getString("pool.default", new Object[0]));
    }

    class LimitedField
    extends JTextField {
        private int column;
        private int length;

        public LimitedField(int column) {
            this.column = column;
            this.enableEvents(8L);
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (this.length >= this.column && e.getKeyCode() == 0 && e.getKeyChar() != '\b') {
                e.consume();
            }
            if (e.getID() == 402) {
                this.length = this.getText().length();
            }
            super.processKeyEvent(e);
        }
    }

    class BindingChecker
    implements BindingListener {
        BindingChecker() {
        }

        public void bindingBecameBound(Binding binding) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void bindingBecameUnbound(Binding binding) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void syncFailed(Binding binding, Binding.SyncFailure failure) {
            ResourceMap resourceMap = Application.getInstance(CoreTest2App.class).getContext().getResourceMap(CoreTest2View.class);
            if ("setUp.size".equals(binding.getName())) {
                if (failure.getType() == Binding.SyncFailureType.CONVERSION_FAILED) {
                    CoreTest2View.this.jLabel2.setText(resourceMap.getString("number.format.error", new Object[0]));
                } else if (failure.getType() == Binding.SyncFailureType.VALIDATION_FAILED) {
                    if (failure.getValidationResult().getErrorCode() == MinMaxValidator.ErrorCode.BELOW_MIN) {
                        CoreTest2View.this.jLabel2.setText(String.format(resourceMap.getString("min.value.error", new Object[0]), CoreTest2View.this.minMaxValidator1.getMin(), CoreTest2View.this.minMaxValidator1.getMax()));
                    } else if (failure.getValidationResult().getErrorCode() == MinMaxValidator.ErrorCode.ABOVE_MAX) {
                        CoreTest2View.this.jLabel2.setText(String.format(resourceMap.getString("max.value.error", new Object[0]), CoreTest2View.this.minMaxValidator1.getMin(), CoreTest2View.this.minMaxValidator1.getMax()));
                    } else {
                        CoreTest2View.this.jLabel2.setText(resourceMap.getString("invalid.value.error", new Object[0]));
                    }
                }
            } else if ("setUp.pool".equals(binding.getName())) {
                if (failure.getType() == Binding.SyncFailureType.CONVERSION_FAILED) {
                    CoreTest2View.this.jLabel5.setText(resourceMap.getString("number.format.error", new Object[0]));
                } else if (failure.getType() == Binding.SyncFailureType.VALIDATION_FAILED) {
                    if (failure.getValidationResult().getErrorCode() == MinMaxValidator.ErrorCode.BELOW_MIN) {
                        CoreTest2View.this.jLabel5.setText(String.format(resourceMap.getString("min.value.error", new Object[0]), CoreTest2View.this.minMaxValidator2.getMin(), CoreTest2View.this.minMaxValidator2.getMax()));
                    } else if (failure.getValidationResult().getErrorCode() == MinMaxValidator.ErrorCode.ABOVE_MAX) {
                        CoreTest2View.this.jLabel5.setText(String.format(resourceMap.getString("max.value.error", new Object[0]), CoreTest2View.this.minMaxValidator2.getMin(), CoreTest2View.this.minMaxValidator2.getMax()));
                    } else {
                        CoreTest2View.this.jLabel5.setText(resourceMap.getString("invalid.value.error", new Object[0]));
                    }
                }
            }
        }

        public void synced(Binding binding) {
            if ("setUp.size".equals(binding.getName())) {
                CoreTest2View.this.jLabel2.setText("");
            } else if ("setUp.pool".equals(binding.getName())) {
                CoreTest2View.this.jLabel5.setText("");
            }
        }

        public void sourceChanged(Binding binding, PropertyStateEvent arg1) {
        }

        public void targetChanged(Binding binding, PropertyStateEvent arg1) {
        }
    }

    private class CallTaskTask
    extends Task<Object, String> {
        String poolSize;
        String threadSize;
        int POOL_SIZE;
        int THREAD_SIZE;
        private long stime;

        CallTaskTask(Application app) {
            super(app);
            this.poolSize = CoreTest2View.this.jTextField2.getText();
            this.threadSize = CoreTest2View.this.jTextField1.getText();
            this.POOL_SIZE = Integer.parseInt(this.poolSize);
            this.THREAD_SIZE = Integer.parseInt(this.threadSize);
            CoreTest2View.this.ctt = this;
        }

        @Override
        protected List<String> doInBackground() throws InterruptedException {
            this.setMessage("Run.");
            String s = null;
            CoreTest2View.this.ex = Executors.newFixedThreadPool(this.POOL_SIZE);
            ArrayList<Future> futures = new ArrayList<Future>();
            this.stime = System.currentTimeMillis();
            for (int i = 0; i < this.THREAD_SIZE; ++i) {
                Future f = CoreTest2View.this.ex.submit(new CalculationCall());
                futures.add(f);
            }
            for (Future f : futures) {
                try {
                    s = (String)f.get();
                }
                catch (InterruptedException ex1) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex1);
                }
                catch (ExecutionException ex1) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex1);
                }
                if (CoreTest2View.this.ex.isShutdown() || s == null) continue;
                this.publish(s);
            }
            return null;
        }

        @Override
        protected void process(List<String> chunks) {
            for (String s : chunks) {
                CoreTest2View.this.jTextArea1.append(s + "\n");
            }
        }

        @Override
        protected void succeeded(Object result) {
            this.stime = System.currentTimeMillis() - this.stime;
            double dStime = this.stime;
            System.out.println(dStime);
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            double tStime = dStime / 1000.0;
            System.out.println(nf.format(tStime));
            CoreTest2View.this.jButton1.setText("\u30b9\u30bf\u30fc\u30c8");
            CoreTest2View.this.jButton1.setEnabled(true);
            CoreTest2View.this.jButton2.setEnabled(false);
            String resultset = "\u51e6\u7406\u6642\u9593\u306f\u3001" + nf.format(tStime) + "\u79d2\u3067\u3057\u305f\u3002";
            CoreTest2View.this.resultLabel.setText(resultset);
            ResourceMap resourceMap = Application.getInstance(CoreTest2App.class).getContext().getResourceMap(CoreTest2View.class);
            CoreTest2View.this.resultLabel.setIcon(resourceMap.getIcon("resultSetIcon"));
        }

        @Override
        protected void finished() {
            Toolkit.getDefaultToolkit().beep();
            this.setMessage(this.isCancelled() ? "Canceled." : "Done.");
            CoreTest2View.this.ctt = null;
        }

        @Override
        protected void cancelled() {
            List<Runnable> shutdownNow = CoreTest2View.this.ex.shutdownNow();
            System.out.println("shutdown size = " + shutdownNow.size());
            if (CoreTest2View.this.ex.isShutdown()) {
                System.out.println("ex = shutdown");
            } else {
                System.out.println("ex = run");
            }
            CoreTest2View.this.ex = null;
            CoreTest2View.this.jButton1.setText("\u30b9\u30bf\u30fc\u30c8");
            CoreTest2View.this.jButton1.setEnabled(true);
            CoreTest2View.this.jButton2.setEnabled(false);
            ResourceMap resourceMap = Application.getInstance(CoreTest2App.class).getContext().getResourceMap(CoreTest2View.class);
            CoreTest2View.this.resultLabel.setText(resourceMap.getString("result.cancel", new Object[0]));
            CoreTest2View.this.resultLabel.setIcon(resourceMap.getIcon("cancelIcon"));
        }
    }
}

